<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Gasto extends Model 
{

    protected $table = 'gastos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nombre');
    protected $visible = array('nombre');

    public function info()
    {
        return $this->hasMany('App\Moron\Models\InformacionGasto');
    }

    public function panel()
    {
        return $this->belongsTo('App\Moron\Models\Panel');
    }

}